<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CreatorStagesParts
 *
 * @ORM\Table(name="creator_stages_parts")
 * @ORM\Entity
 */
class CreatorStagesParts
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $id;

    /**
     * @var float $start
     *
     * @ORM\Column(name="start", type="float")
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $start;

    /**
     * @var float $end
     *
     * @ORM\Column(name="end", type="float")
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $end;

    /**
     * @var float $percentPoint
     *
     * @ORM\Column(name="percent_point", type="float")
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $percentPoint;

    /**
     * @var integer $index
     *
     * @ORM\Column(name="part_index", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $index;

    /**
     * @var integer
     *
     * @ORM\Column(name="stage_id", type="integer")
     *
     */
    private $stageId;

    /**
     * @ORM\ManyToOne(targetEntity="CreatorStages",inversedBy="parts")
     * @ORM\JoinColumn(name="stage_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"partsList"})
     */
    private $stage;

    /**
     * @var integer $step_index
     *
     * @ORM\Column(name="step_index", type="integer", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $step_index;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set start
     *
     * @param float $start
     * @return CreatorStagesParts
     */
    public function setStart($start)
    {
        $this->start = $start;
    
        return $this;
    }

    /**
     * Get start
     *
     * @return float 
     */
    public function getStart()
    {
        return $this->start;
    }

    /**
     * Set end
     *
     * @param float $end
     * @return CreatorStagesParts
     */
    public function setEnd($end)
    {
        $this->end = $end;
    
        return $this;
    }

    /**
     * Get end
     *
     * @return float 
     */
    public function getEnd()
    {
        return $this->end;
    }

    /**
     * Set percentPoint
     *
     * @param float $percentPoint
     * @return CreatorStagesParts
     */
    public function setPercentPoint($percentPoint)
    {
        $this->percentPoint = $percentPoint;
    
        return $this;
    }

    /**
     * Get percentPoint
     *
     * @return float 
     */
    public function getPercentPoint()
    {
        return $this->percentPoint;
    }

    /**
     * Set index
     *
     * @param integer $index
     * @return CreatorStagesParts
     */
    public function setIndex($index)
    {
        $this->index = $index;
    
        return $this;
    }

    /**
     * Get index
     *
     * @return integer 
     */
    public function getIndex()
    {
        return $this->index;
    }

    /**
     * Set stageId
     *
     * @param integer $stageId
     * @return CreatorStagesParts
     */
    public function setStageId($stageId)
    {
        $this->stageId = $stageId;
    
        return $this;
    }

    /**
     * Get stageId
     *
     * @return integer 
     */
    public function getStageId()
    {
        return $this->stageId;
    }

    /**
     * Set step_index
     *
     * @param integer $stepIndex
     * @return CreatorStagesParts
     */
    public function setStepIndex($stepIndex)
    {
        $this->step_index = $stepIndex;
    
        return $this;
    }

    /**
     * Get step_index
     *
     * @return integer 
     */
    public function getStepIndex()
    {
        return $this->step_index;
    }

    /**
     * Set stage
     *
     * @param \VM\ApiBundle\Entity\CreatorStages $stage
     * @return CreatorStagesParts
     */
    public function setStage(\VM\ApiBundle\Entity\CreatorStages $stage = null)
    {
        $this->stage = $stage;
    
        return $this;
    }

    /**
     * Get stage
     *
     * @return \VM\ApiBundle\Entity\CreatorStages 
     */
    public function getStage()
    {
        return $this->stage;
    }
}